/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item.consumables;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.redspace.ironsspellbooks.effect.CustomDescriptionMobEffect;
import io.redspace.ironsspellbooks.item.consumables.DrinkableItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SimpleElixir
extends DrinkableItem {
    private final Supplier<MobEffectInstance> potionEffect;
    boolean foilOverride;

    public SimpleElixir(Item.Properties pProperties, Supplier<MobEffectInstance> potionEffect) {
        super(pProperties, SimpleElixir::applyEffect, Items.f_42590_, true);
        this.potionEffect = potionEffect;
    }

    public SimpleElixir(Item.Properties pProperties, Supplier<MobEffectInstance> potionEffect, boolean foil) {
        this(pProperties, potionEffect);
        this.foilOverride = foil;
    }

    public MobEffectInstance getMobEffect() {
        return this.potionEffect.get();
    }

    private static void applyEffect(ItemStack itemStack, LivingEntity livingEntity) {
        Item item = itemStack.m_41720_();
        if (item instanceof SimpleElixir) {
            SimpleElixir elixir = (SimpleElixir)item;
            if (elixir.potionEffect.get() != null) {
                livingEntity.m_7292_(elixir.potionEffect.get());
            }
        }
    }

    public boolean m_5812_(ItemStack pStack) {
        return super.m_5812_(pStack) || this.foilOverride;
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        SimpleElixir.addPotionTooltip(this.potionEffect.get(), pTooltipComponents, 1.0f);
        MobEffect mobEffect = this.potionEffect.get().m_19544_();
        if (mobEffect instanceof CustomDescriptionMobEffect) {
            CustomDescriptionMobEffect customDescriptionMobEffect = (CustomDescriptionMobEffect)mobEffect;
            CustomDescriptionMobEffect.handleCustomPotionTooltip(pStack, pTooltipComponents, false, this.potionEffect.get(), customDescriptionMobEffect);
        }
    }

    public int getMaxStackSize(ItemStack stack) {
        return Items.f_42589_.m_41459_();
    }

    public static void addPotionTooltip(MobEffectInstance mobeffectinstance, List<Component> pTooltips, float pDurationFactor) {
        ArrayList list1 = Lists.newArrayList();
        MutableComponent mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
        MobEffect mobeffect = mobeffectinstance.m_19544_();
        Map map = mobeffect.m_19485_();
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), mobeffect.m_7048_(mobeffectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
            }
        }
        if (mobeffectinstance.m_19564_() > 0) {
            mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + mobeffectinstance.m_19564_()))});
        }
        if (mobeffectinstance.m_19557_() > 20) {
            mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_19581_((MobEffectInstance)mobeffectinstance, (float)pDurationFactor)});
        }
        pTooltips.add((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
        if (!list1.isEmpty()) {
            pTooltips.add(CommonComponents.f_237098_);
            pTooltips.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    pTooltips.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                pTooltips.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

